%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% function P = greedy_search(P,A,B,max_swap)
%
% Iteratively computes the gains from all pairwise
% swaps and performs up to max_swaps swaps per 
% iteration.
%
% P is the current permutation matrix.
% A and B are the graphs being matched.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [P,scoreP] = greedy_search(P,A,B,max_swap)

% SETUP
tStart = tic;
secs_per_minute = 60;
scoreP = full(sum(min(A*P,P*B),'all'));
fprintf(1,'%%\n%% Pairwise swaps:\n');
fprintf(1,'%%  iter     score    swaps    tMin   tMatch\n');
fprintf(1,'    %03d   %07d   %6d    %04.1f   0\n',0,scoreP,0,0);

% LOOP
iter = 1;
[D,dMax] = evaluate_swaps(P,A,B);
while (dMax>0)
  [P,scoreP,num_swap] = make_swaps(P,D,A,B,max_swap);
  tMin = toc(tStart)/secs_per_minute;
  fprintf(1,'    %03d   %07d   %6d    %04.1f   0\n',...
    iter,scoreP,num_swap,tMin);
  [D,dMax] = evaluate_swaps(P,A,B);
  iter = iter+1;
end

% DONE
tMin = toc(tStart)/secs_per_minute;
fprintf(1,'    %03d   %07d   %6d    %04.1f   0\n',iter,scoreP,0,tMin);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
